import 'package:get/get.dart';
import 'package:json_annotation/json_annotation.dart';
import '../screen/pageDetail/campaign_detail_screen.dart';
import 'directional_action_type.dart';

part 'directional_screen.g.dart';
@JsonSerializable()
class DirectionalScreen {
  @JsonKey(name: "click_action_type")
  final String? clickActionType;
  @JsonKey(name: "click_action_param")
  final String? clickActionParam;
  final ClickActionType? actionType;

  DirectionalScreen({
    this.clickActionType,
    this.clickActionParam,
    this.actionType,
  });

  factory DirectionalScreen.fromJson(Map<String, dynamic> json) => _$DirectionalScreenFromJson(json);
  Map<String, dynamic> toJson() => _$DirectionalScreenToJson(this);

  void begin() {
    final type = ClickActionTypeExtension.fromString(clickActionType ?? actionType?.key ?? "");
    if (type == null) {
      print("Không nhận diện được action type: $clickActionType");
      return;
    }

    switch (type) {
      case ClickActionType.campaignDetail:
        Get.to(() => const CampaignDetailScreen(), arguments: clickActionParam);
        break;
    }
  }
}