import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import 'package:mypoint_flutter_app/screen/login/login_screen.dart';
import 'package:mypoint_flutter_app/screen/main_tab_screen/main_tab_screen.dart';
import 'package:mypoint_flutter_app/screen/onboarding/onboarding_screen.dart';
import 'package:mypoint_flutter_app/screen/onboarding/onboarding_viewmodel.dart';
import 'package:mypoint_flutter_app/screen/splash/splash_screen.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await DataPreference.instance.loadLoginToken();
  Get.put(OnboardingViewModel());
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      debugShowCheckedModeBanner: false,
      initialRoute: '/login',
      theme: ThemeData(
        colorScheme: ColorScheme.fromSwatch(primarySwatch: Colors.deepPurple),
        primaryColor: Colors.deepPurple,
      ),
      home: SplashScreen(),
      getPages: [
        GetPage(name: '/login', page: () => const LoginScreen(phoneNumber: '091212121',)),
        GetPage(name: '/main', page: () => const MainTabScreen()),
        GetPage(name: '/onboarding', page: () => const OnboardingScreen()),
      ],
    );
  }
}