import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/model/auth/customer_balance_model.dart';
import 'customer_balance_model.dart';


part 'working_site_model.g.dart';

@JsonSerializable()
class WorkingSiteModel {
  final String? id;
  final String? name;
  final String? avatar;

  @JsonKey(name: 'customer_balance')
  final CustomerBalanceModel? customerBalanceModel;

  @JsonKey(name: 'primary_membership')
  // final PrimaryMembership? primaryMembership;

  WorkingSiteModel({
    this.id,
    this.name,
    this.avatar,
    this.customerBalanceModel,
    // this.primaryMembership,
  });

  factory WorkingSiteModel.fromJson(Map<String, dynamic> json) => _$WorkingSiteModelFromJson(json);
  Map<String, dynamic> toJson() => _$WorkingSiteModelToJson(this);
}
