import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/resouce/base_color.dart';

enum TextStyleIconAndText {
  header1,
  header2,
  header3,
  normal,
  underline,
  normalDisable,
  normalButton,
}

TextStyle header1 = TextStyle(
  fontSize: 22,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
TextStyle header2 = TextStyle(
  fontSize: 18,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
TextStyle header3 = TextStyle(
  fontSize: 16,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
const TextStyle textNormal = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.normal,
  color: Colors.black,
);
const TextStyle textMedium = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.w500,
  color: Colors.black,
);
const TextStyle textSemiBold = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.w600,
  color: Colors.black,
);
TextStyle textBold = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.bold,
  color: Colors.black,
);
TextStyle underline = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.normal,
  decoration: TextDecoration.underline,
  color: Colors.blue,
);
TextStyle normalDisable = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.bold,
  color: Colors.grey,
);
TextStyle normalButton = TextStyle(
  fontSize: 14,
  fontWeight: FontWeight.bold,
  color: Colors.white,
);

TextStyle getTextStyle(TextStyleIconAndText? textType) {
  switch (textType) {
    case TextStyleIconAndText.header1:
      return header1;
    case TextStyleIconAndText.header2:
      return header2;
    case TextStyleIconAndText.header3:
      return header3;
    case TextStyleIconAndText.normal:
      return textNormal;
    case TextStyleIconAndText.underline:
      return underline;
    case TextStyleIconAndText.normalDisable:
      return normalDisable;
    case TextStyleIconAndText.normalButton:
      return normalButton;
    default:
      return textNormal;
  }
}

final BorderRadius _borderRadius = BorderRadius.circular(8.0);
final BorderSide _defaultBorderSide = BorderSide(color: BaseColor.second400);
final BorderSide _focusedBorderSide = BorderSide(color: Colors.blue);
final EdgeInsets _contentPadding = EdgeInsets.symmetric(vertical: 16.0, horizontal: 16.0);

class PTTextStyles {
  static final InputDecoration textFieldDecoration = InputDecoration(
    border: OutlineInputBorder(
      borderRadius: _borderRadius,
      borderSide: _defaultBorderSide,
    ),
    enabledBorder: OutlineInputBorder(
      borderRadius: _borderRadius,
      borderSide: _defaultBorderSide,
    ),
    focusedBorder: OutlineInputBorder(
      borderRadius: _borderRadius,
      borderSide: _focusedBorderSide,
    ),
    labelText: 'Enter text',
    labelStyle: TextStyle(color: Colors.grey),
    hintText: 'Hint text',
    hintStyle: TextStyle(color: Colors.grey),
    filled: true,
    fillColor: Colors.white,
    contentPadding: _contentPadding,
  );
}
