import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import 'package:mypoint_flutter_app/screen/create_pass/signup_create_password_repository.dart';
import '../../base/base_response_model.dart';
import '../../base/restful_api_viewmodel.dart';
import '../login/login_screen.dart';
import '../splash/splash_screen_viewmodel.dart';

class ResetCreatePasswordRepository extends RestfulApiViewModel implements ICreatePasswordRepository {
  @override
  late String phoneNumber;

  ResetCreatePasswordRepository(this.phoneNumber);

  @override
  Future<BaseResponseModel<EmptyCodable>> setPassword(String password) async {
    showLoading();
    return client.accountPasswordReset(phoneNumber, password).then((value) {
      hideLoading();
      if (value.status == "success" || value.code == 200) {
        print("Reset password success");
        Get.off(() => LoginScreen(phoneNumber: phoneNumber));
      }
      return value;
    });
  }
}
