import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/screen/pageDetail/campaign_detail_screen.dart';
import 'package:mypoint_flutter_app/widgets/back_button.dart';
import '../../base/base_screen.dart';
import '../../base/basic_state.dart';
import '../../resouce/base_color.dart';
import 'faqs_viewmodel.dart';

class FAQScreen extends BaseScreen {
  const FAQScreen({super.key});

  @override
  State<FAQScreen> createState() => _FAQScreenState();
}

class _FAQScreenState extends BaseState<FAQScreen> with BasicState {
  final FAQViewModel _controller = Get.put(FAQViewModel());

  @override
  Widget createBody() {
    return Scaffold(
      appBar: AppBar(
        leading: CustomBackButton(),
        title: const Text("Câu hỏi thường gặp", style: TextStyle(fontWeight: FontWeight.bold)),
        backgroundColor: Colors.white,
        foregroundColor: Colors.black,
        elevation: 0,
      ),
      body: Column(
        children: [
          Obx(() {
            if (_controller.isLoading.value) {
              return const Expanded(child: Center(child: CircularProgressIndicator()));
            }
            if (_controller.faqItems.isEmpty) {
              return const Expanded(child: Center(child: Text("Không có dữ liệu.")));
            }
            return Expanded(child: _buildFAQList());
          }),
        ],
      ),
    );
  }

  Widget _buildFAQList() {
    return ListView.builder(
      itemCount: _controller.faqItems.length,
      itemBuilder: (context, index) {
        final item = _controller.faqItems[index];
        return GestureDetector(
          onTap: () {
            if (item.pageId != null && item.pageId!.isNotEmpty) {
              Get.to(() => CampaignDetailScreen(pageId: item.pageId));
            } else {
              Get.snackbar(
                "Thông báo",
                "Không thể mở chi tiết vì thiếu ID!",
                backgroundColor: Colors.redAccent,
                colorText: Colors.white,
              );
            }
          },
          child: Column(
            children: [
              Container(
                color: BaseColor.second200,
                child: ListTile(
                  leading: const Icon(Icons.help_outline, color: BaseColor.second500),
                  title: Text(
                    item.title ?? "",
                    style: const TextStyle(fontWeight: FontWeight.bold, color: BaseColor.second700),
                  ),
                  trailing: Icon(Icons.arrow_forward_ios, size: 16, color: BaseColor.second500),
                ),
              ),
              const SizedBox(height: 8),
              Padding(
                padding: const EdgeInsets.only(left: 56, right: 16, bottom: 10), // 👈 56 = icon width + padding mặc định
                child: Align(
                  alignment: Alignment.centerLeft,
                  child: Text(item.chapeau ?? "", style: const TextStyle(fontSize: 16, color: BaseColor.second500)),
                ),
              ),
              const SizedBox(height: 8),
            ],
          ),
        );
      },
    );
  }
}
