import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class PersonalScreen extends StatelessWidget {
  const PersonalScreen({super.key});

  @override
  Widget build(BuildContext context) {
    // Set status bar to transparent to allow banner to extend under it
    SystemChrome.setSystemUIOverlayStyle(
      const SystemUiOverlayStyle(
        statusBarColor: Colors.transparent,
        statusBarIconBrightness: Brightness.light,
      ),
    );

    return Scaffold(
      body: Column(
        children: [
          // Header with gradient that extends under status bar
          _buildHeader(),

          // Scrollable content
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: [
                  // Special invitation section
                  _buildInvitationSection(),

                  // Regular menu items
                  _buildMenuItems(),

                  _buildVersionInfo(),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildHeader() {
    return Container(
      decoration: const BoxDecoration(
        gradient: LinearGradient(
          begin: Alignment.topCenter,
          end: Alignment.bottomCenter,
          colors: [
            Color(0xFFE83A5D),
            Color(0xFFD13A5D),
          ],
        ),
      ),
      child: SafeArea(
        top: false, // Extend under status bar
        bottom: false,
        child: Padding(
          padding: const EdgeInsets.fromLTRB(16, 40, 16, 16),
          child: Column(
            children: [
              Row(
                children: [
                  Container(
                    width: 40,
                    height: 40,
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(color: Colors.amber, width: 2),
                    ),
                    child: const Center(
                      child: Text(
                        "U",
                        style: TextStyle(
                          color: Colors.red,
                          fontWeight: FontWeight.bold,
                          fontSize: 20,
                        ),
                      ),
                    ),
                  ),
                  const SizedBox(width: 12),
                  const Text(
                    "Quý khách",
                    style: TextStyle(
                      color: Colors.white,
                      fontWeight: FontWeight.bold,
                      fontSize: 18,
                    ),
                  ),
                  const Spacer(),
                  const Icon(
                    Icons.chevron_right,
                    color: Colors.white,
                  ),
                ],
              ),
              const SizedBox(height: 16),
              Row(
                children: [
                  Container(
                    padding: const EdgeInsets.all(4),
                    decoration: BoxDecoration(
                      color: Colors.amber,
                      borderRadius: BorderRadius.circular(4),
                    ),
                    child: const Icon(
                      Icons.star,
                      color: Colors.red,
                      size: 16,
                    ),
                  ),
                  const SizedBox(width: 8),
                  const Text(
                    "Chi tiết đối tác",
                    style: TextStyle(
                      color: Colors.white,
                      fontWeight: FontWeight.w500,
                      fontSize: 14,
                    ),
                  ),
                  const Spacer(),
                  const Text(
                    "0 điểm",
                    style: TextStyle(
                      color: Colors.white,
                      fontWeight: FontWeight.bold,
                      fontSize: 14,
                    ),
                  ),
                  const SizedBox(width: 4),
                  const Icon(
                    Icons.chevron_right,
                    color: Colors.white,
                    size: 20,
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildInvitationSection() {
    return Container(
      color: Colors.white,
      child: ListTile(
        leading: Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            Image.asset(
              'assets/gift_characters.png',
              width: 40,
              height: 40,
              errorBuilder: (context, error, stackTrace) {
                // Fallback if image is not available
                return Container(
                  width: 40,
                  height: 40,
                  decoration: BoxDecoration(
                    color: Colors.pink[50],
                    borderRadius: BorderRadius.circular(20),
                  ),
                  child: Icon(Icons.people, color: Colors.red[300], size: 24),
                );
              },
            ),
          ],
        ),
        title: const Text(
          'Mời bạn nhận quà liền tay 🎁',
          style: TextStyle(
            fontSize: 14,
            fontWeight: FontWeight.w500,
          ),
        ),
        trailing: const Icon(
          Icons.chevron_right,
          color: Colors.grey,
          size: 20,
        ),
        contentPadding: const EdgeInsets.symmetric(horizontal: 16),
        minLeadingWidth: 40,
      ),
    );
  }

  Widget _buildMenuItems() {
    final menuItems = [
      {
        'icon': Icons.monetization_on,
        'title': 'Săn điểm',
        'iconColor': Colors.amber,
        'showDivider': true,
      },
      {
        'icon': Icons.check_box_outlined,
        'title': 'Check-in nhận quà',
        'iconColor': Colors.blue[300],
        'showDivider': true,
      },
      {
        'icon': Icons.emoji_events_outlined,
        'title': 'Bảng xếp hạng',
        'iconColor': Colors.amber[700],
        'showDivider': true,
      },
      {
        'icon': Icons.local_offer_outlined,
        'title': 'Ưu đãi của tôi',
        'iconColor': Colors.purple[300],
        'showDivider': true,
      },
      {
        'icon': Icons.history_outlined,
        'title': 'Lịch sử điểm',
        'iconColor': Colors.blue[300],
        'showDivider': true,
      },
      {
        'icon': Icons.history_outlined,
        'title': 'Lịch sử hoàn điểm',
        'iconColor': Colors.blue[300],
        'showDivider': true,
      },
      {
        'icon': Icons.account_balance_wallet_outlined,
        'title': 'Quản lý tài khoản/thẻ',
        'iconColor': Colors.green[300],
        'showDivider': true,
      },
      {
        'icon': Icons.favorite_border,
        'title': 'Yêu thích',
        'iconColor': Colors.red[300],
        'showDivider': true,
        'sectionDivider': false,
      },
      {
        'icon': Icons.receipt_long_outlined,
        'title': 'Lịch sử giao dịch',
        'iconColor': Colors.blue[300],
        'showDivider': true,
        'sectionDivider': true,
      },
      {
        'icon': Icons.shopping_bag_outlined,
        'title': 'Đơn mua',
        'iconColor': Colors.orange[300],
        'showDivider': true,
      },
      {
        'icon': Icons.info_outline,
        'title': 'Giới thiệu MyPoint',
        'iconColor': Colors.blue[300],
        'showDivider': true,
        'sectionDivider': true
      },
      {
        'icon': Icons.settings_outlined,
        'title': 'Cài đặt',
        'iconColor': Colors.grey[600],
        'showDivider': true,
      },
      {
        'icon': Icons.headset_mic_outlined,
        'title': 'Hỗ trợ',
        'iconColor': Colors.blue[300],
        'showDivider': true,
      },
      {
        'icon': Icons.logout,
        'title': 'Đăng xuất',
        'iconColor': Colors.red[400],
        'showDivider': false,
      },
    ];

    return Container(
      color: Colors.white,
      child: Column(
        children: menuItems.map((item) {
          // Check if this item needs a section divider before it
          final needsSectionDivider = item['sectionDivider'] == true;

          return Column(
            children: [
              // Add section divider if needed
              if (needsSectionDivider)
                Container(
                  height: 8,
                  color: Colors.grey[100],
                ),

              ListTile(
                leading: Icon(
                  item['icon'] as IconData,
                  color: item['iconColor'] as Color?,
                  size: 24,
                ),
                title: Text(
                  item['title'] as String,
                  style: const TextStyle(
                    fontSize: 14,
                    fontWeight: FontWeight.w500,
                  ),
                ),
                trailing: const Icon(
                  Icons.chevron_right,
                  color: Colors.grey,
                  size: 20,
                ),
                contentPadding: const EdgeInsets.symmetric(horizontal: 16),
                minLeadingWidth: 24,
              ),

              // Add regular divider if needed
              if (item['showDivider'] == true)
                const Divider(height: 1, indent: 56, endIndent: 0),
            ],
          );
        }).toList(),
      ),
    );
  }

  Widget _buildVersionInfo() {
    return Container(
      padding: const EdgeInsets.symmetric(vertical: 12),
      alignment: Alignment.center,
      child: const Text(
        "Phiên bản: 1.21.10(25032101)",
        style: TextStyle(
          color: Colors.grey,
          fontSize: 12,
        ),
      ),
    );
  }
}