import 'dart:io';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/configs/api_paths.dart';
import 'package:mypoint_flutter_app/dio_http_service/api_helper.dart';
import 'package:mypoint_flutter_app/networking/api_service.dart';
import 'package:mypoint_flutter_app/screen/splash/splash_screen_viewmodel.dart';

import '../../model/check_update_response_model.dart';
import '../onboarding/onboarding_screen.dart';


class SplashScreen extends StatefulWidget {
  const SplashScreen({super.key});

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends State<SplashScreen> with ApiHelper {
  final SplashScreenViewModel _viewModel = Get.put(SplashScreenViewModel());

  @override
  void initState() {
    super.initState();
    initNetWork(APIPaths.baseUrl);
    _viewModel.checkUpdateApp();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.blue,
      body: Stack(
        children: [
          Container(
            width: double.infinity,
            height: double.infinity,
            decoration: BoxDecoration(
              image: DecorationImage(image: AssetImage("assets/images/splash_screen.png"), fit: BoxFit.cover),
            ),
          ),

          Obx(() {
            if (_viewModel.isLoading.value) {
              return Center(child: CircularProgressIndicator());
            } else {
              WidgetsBinding.instance.addPostFrameCallback((_) {
                var status = _viewModel.infoAppUpdate.value?.data?.data?.updateRequest?.first?.status ?? UpdateStatus.none;
                if (status == UpdateStatus.force) {
                  _showForceUpdateAlert();
                } else if (status == UpdateStatus.suggest) {
                  _showSuggestUpdateAlert();
                } else {
                  _navigateToBeforCheckUpdate();
                }
              });
              return Container(width: double.infinity, height: double.infinity, color: Colors.black.withOpacity(0.5));
            }
          }),
        ],
      ),
    );
  }

  void _exitApp() {
    if (Platform.isAndroid) {
      SystemNavigator.pop();
    } else {
      exit(0);
    }
  }

  void _navigateToBeforCheckUpdate() {
    Get.to(OnboardingScreen());
  }

  void _showForceUpdateAlert() {
    showDialog(
      context: context,
      barrierDismissible: false, // Không cho dismiss ngoài Alert
      builder: (context) {
        return AlertDialog(
          title: Text("Cập nhật bắt buộc"),
          content: Text("Phiên bản app của bạn đã cũ. Bạn phải cập nhật để tiếp tục sử dụng."),
          actions: [
            TextButton(
              onPressed: () async {
                // Sau khi nhấn update, bạn có thể đóng app nếu không cập nhật được.
                _exitApp();
              },
              child: Text("Cập nhật ngay"),
            ),
            TextButton(
              onPressed: () {
                // Nếu người dùng không cập nhật, đóng app.
                _exitApp();
              },
              child: Text("Thoát"),
            ),
          ],
        );
      },
    );
  }

  void _showSuggestUpdateAlert() {
    showDialog(
      context: context,
      barrierDismissible: false, // Buộc người dùng chọn
      builder: (context) {
        return AlertDialog(
          title: Text("Gợi ý cập nhật"),
          content: Text("Có phiên bản mới của app. Bạn có muốn cập nhật không?"),
          actions: [
            TextButton(onPressed: () async {}, child: Text("Cập nhật ngay")),
            TextButton(
              onPressed: () {
                // Cho phép sử dụng app mà không cập nhật ngay
                _navigateToBeforCheckUpdate();
              },
              child: Text("Để sau"),
            ),
          ],
        );
      },
    );
  }

  Future<void> fetchCheckUpdate() async {
    final response = await ApiService().checkUpdateWithRequestManager();
    if (response != null) {
      if (response.status == UpdateStatus.force) {
        _showForceUpdateAlert();
      } else if (response.status == UpdateStatus.suggest) {
        _showSuggestUpdateAlert();
      } else {
        _showForceUpdateAlert();
        // _navigateToHome();
      }
    } else {
      _showSuggestUpdateAlert();
      // _navigateToHome();
    }
  }
}
