# Cấu trúc thư mục Project

Tài liệu này mô tả chi tiết cấu trúc thư mục của MyPoint Flutter App.

```
flutter_app_mypoint/
├── lib/                          # Source code chính
│   ├── main.dart                 # Entry point
│   ├── env_loader.dart           # Environment loader
│   │
│   ├── base/                     # Base classes và utilities
│   │   ├── app_loading.dart
│   │   ├── app_navigator.dart
│   │   ├── base_response_model.dart
│   │   ├── base_screen.dart
│   │   ├── base_view_model.dart
│   │   └── basic_state.dart
│   │
│   ├── core/                     # Core initialization
│   │   ├── app_initializer.dart
│   │   ├── web_app_initializer.dart
│   │   └── deep_link_service.dart
│   │
│   ├── configs/                  # Configuration
│   │   ├── api_paths.dart
│   │   ├── callbacks.dart
│   │   ├── constants.dart
│   │   └── device_info.dart
│   │
│   ├── extensions/               # Extension methods
│   │   ├── collection_extension.dart
│   │   ├── color_extension.dart
│   │   ├── crypto.dart
│   │   ├── date_format.dart
│   │   ├── datetime_extensions.dart
│   │   ├── debouncer.dart
│   │   ├── num_extension.dart
│   │   └── string_extension.dart
│   │
│   ├── firebase/                 # Firebase integration
│   │   ├── firebase_options.dart
│   │   ├── notification_parse_payload.dart
│   │   ├── push_notification.dart
│   │   ├── push_setup.dart
│   │   └── push_token_service.dart
│   │
│   ├── model/                    # Data models
│   │   └── auth/                 # Authentication models
│   │       ├── biometric_register_response_model.dart
│   │       ├── customer_balance_model.dart
│   │       ├── login_token_response_model.dart
│   │       ├── profile_response_model.dart
│   │       ├── user_agreement_model.dart
│   │       ├── worker_site_model.dart
│   │       └── working_site_model.dart
│   │
│   ├── networking/               # Network layer
│   │   ├── api/                  # API clients
│   │   │   ├── affiliate_api.dart
│   │   │   ├── game_api.dart
│   │   │   ├── location_api.dart
│   │   │   ├── notification_api.dart
│   │   │   ├── product_api.dart
│   │   │   └── website_api.dart
│   │   ├── interceptor/         # HTTP interceptors
│   │   │   ├── auth_interceptor.dart
│   │   │   ├── exception_interceptor.dart
│   │   │   ├── logger_interceptor.dart
│   │   │   ├── network_error_gate.dart
│   │   │   └── request_interceptor.dart
│   │   ├── dio_extra_keys.dart
│   │   ├── dio_http_service.dart
│   │   ├── error_mapper.dart
│   │   ├── restful_api_client.dart
│   │   ├── restful_api_client_all_request.dart
│   │   └── restful_api_viewmodel.dart
│   │
│   ├── permission/               # Permissions
│   │   └── biometric_manager.dart
│   │
│   ├── preference/               # Local storage
│   │   ├── contact_storage_service.dart
│   │   ├── data_preference.dart
│   │   ├── package_info.dart
│   │   └── point/                # Point management
│   │       ├── header_home_model.dart
│   │       ├── header_home_model.g.dart
│   │       └── point_manager.dart
│   │
│   ├── resources/                # Resources
│   │   ├── base_color.dart
│   │   ├── button_style.dart
│   │   ├── define_image.dart
│   │   └── text_style.dart
│   │
│   ├── screen/                   # UI Screens (375+ files)
│   │   ├── achievement/
│   │   ├── affiliate/
│   │   ├── affiliate_brand_detail/
│   │   ├── bank_account_manager/
│   │   ├── biometric/
│   │   ├── campaign7day/
│   │   ├── change_pass/
│   │   ├── contacts/
│   │   ├── create_pass/
│   │   ├── daily_checkin/
│   │   ├── data_network_service/
│   │   ├── delete_account/
│   │   ├── device_manager/
│   │   ├── electric_payment/
│   │   ├── faqs/
│   │   ├── flash_sale/
│   │   ├── game/
│   │   ├── health_book/
│   │   ├── history_point/
│   │   ├── history_point_cashback/
│   │   ├── home/                 # Home screen (40 files)
│   │   ├── interested_categories/
│   │   ├── invite_friend_campaign/
│   │   ├── location_address/
│   │   ├── login/
│   │   ├── main_tab_screen/
│   │   ├── membership/
│   │   ├── mobile_card/
│   │   ├── news/
│   │   ├── notification/
│   │   ├── onboarding/
│   │   ├── order_menu/
│   │   ├── otp/
│   │   ├── pageDetail/
│   │   ├── personal/
│   │   ├── pipi/
│   │   ├── popup_manager/
│   │   ├── qr_code/
│   │   ├── quiz_campaign/
│   │   ├── register_campaign/
│   │   ├── setting/
│   │   ├── splash/
│   │   ├── support/
│   │   ├── topup/
│   │   ├── traffic_service/
│   │   ├── transaction/
│   │   ├── voucher/              # Voucher screens (46 files)
│   │   ├── vplay_game_center/
│   │   └── webview/
│   │
│   ├── services/                 # Business services
│   │   ├── login_service.dart
│   │   ├── logout_service.dart
│   │   └── token_refresh_service.dart
│   │
│   ├── shared/                   # Shared utilities
│   │   ├── direction_google_map.dart
│   │   └── router_gage.dart
│   │
│   ├── utils/                    # Utilities
│   │   └── validation_utils.dart
│   │
│   ├── web/                      # Web integration
│   │   ├── x_app_sdk_service.dart
│   │   ├── web_helper.dart
│   │   ├── web_helper_web.dart
│   │   └── web_helper_stub.dart
│   │
│   ├── widgets/                  # Reusable widgets (22 files)
│   │   ├── alert/                # Alert widgets (6 files)
│   │   ├── back_button.dart
│   │   ├── bottom_sheet_helper.dart
│   │   ├── button_container.dart
│   │   ├── custom_app_bar.dart
│   │   ├── custom_empty_widget.dart
│   │   ├── custom_navigation_bar.dart
│   │   ├── custom_point_text_tag.dart
│   │   ├── custom_price_tag.dart
│   │   ├── custom_search_navigation_bar.dart
│   │   ├── custom_toast_message.dart
│   │   ├── dashed_line.dart
│   │   ├── image_loader.dart
│   │   ├── measure_size.dart
│   │   ├── network_image_with_aspect_ratio.dart
│   │   ├── support_button.dart
│   │   └── time_picker_widget.dart
│   │
│   ├── deferred/                 # Deferred loading
│   │   └── deferred_routes.dart
│   │
│   └── directional/              # Direction handling
│       ├── directional_action_type.dart
│       └── directional_screen.dart
│
├── assets/                       # Assets
│   ├── config/                   # Environment configs
│   │   ├── env.json              # Active config (auto-generated)
│   │   └── env_dev.json          # Development config
│   ├── data/                     # Static data
│   │   ├── main_layout_section_home.json
│   │   └── support_data.json
│   ├── icons/                    # App icons by environment
│   │   ├── dev/                  # Development icons
│   │   ├── pro/                  # Production icons
│   │   └── stg/                  # Staging icons
│   └── images/                  # Images (96 files)
│       ├── cashback/             # Cashback category icons
│       ├── splash_screen.png
│       ├── splash_screen.webp
│       └── ... (93 PNG files)
│
├── web/                          # Web assets
│   ├── index.html                # Main HTML file
│   ├── manifest.json            # PWA manifest
│   ├── favicon.png
│   ├── icons/                    # PWA icons
│   │   ├── Icon-192.png
│   │   ├── Icon-512.png
│   │   ├── Icon-maskable-192.png
│   │   └── Icon-maskable-512.png
│   ├── js/                       # JavaScript files
│   │   └── x_app_sdk_loader.js
│   └── assets/
│       └── index.html
│
├── android/                      # Android platform
│   ├── app/
│   │   ├── build.gradle.kts
│   │   ├── google-services.json
│   │   ├── proguard-rules.pro
│   │   ├── keystores/            # Signing keys
│   │   └── src/                  # Android source (57 files)
│   ├── build.gradle.kts
│   ├── gradle/
│   │   └── wrapper/
│   ├── gradle.properties
│   ├── gradlew                   # Gradle wrapper
│   ├── key.properties
│   └── settings.gradle.kts
│
├── ios/                          # iOS platform
│   ├── Flutter/                  # Flutter configs
│   │   ├── AppFrameworkInfo.plist
│   │   ├── Debug.xcconfig
│   │   ├── Dev.xcconfig
│   │   ├── Pro.xcconfig
│   │   ├── Release.xcconfig
│   │   ├── Stg.xcconfig
│   │   └── Generated.xcconfig
│   ├── NotificationServices/     # Notification service extension
│   │   ├── Info.plist
│   │   └── NotificationService.swift
│   ├── Runner/                   # iOS app
│   │   ├── AppDelegate.swift
│   │   ├── Assets.xcassets/      # iOS assets (43 files)
│   │   ├── Base.lproj/           # Storyboards
│   │   ├── Env/                  # Environment configs (3 files)
│   │   ├── GoogleService-Info.plist
│   │   ├── Info.plist
│   │   └── Runner-Bridging-Header.h
│   ├── Runner.xcodeproj/         # Xcode project
│   ├── Runner.xcworkspace/       # Xcode workspace
│   ├── RunnerTests/              # iOS tests
│   ├── Podfile                   # CocoaPods dependencies
│   └── Pods/                     # CocoaPods packages
│
├── test/                         # Tests
│   └── widget_test.dart
│
├── tools/                        # Development tools
│   └── print_size_info.dart
│
├── deploy/                       # Deployment configs
│   └── nginx/                    # Nginx configs
│
├── build/                        # Build output (generated)
│   ├── web/                      # Web build output
│   └── ios/                      # iOS build artifacts
│
├── node_modules/                 # Node.js dependencies
│   └── x-app-sdk/                # X-App-SDK package
│
├── web_dev_export_*/             # Development exports (generated)
│   └── serve_local.sh            # Local server script
│
├── web_prod_export_*/            # Production exports (generated)
│   └── serve_local.sh            # Local server script
│
├── export_dev.sh                 # Export development script
├── export_prod.sh                # Export production script
├── run_dev.sh                    # Run development script
├── run_prod.sh                   # Run production preview script
├── run_dev_nginx.sh              # Build + Nginx setup (all-in-one)
│
├── pubspec.yaml                  # Flutter dependencies
├── pubspec.lock                  # Flutter lock file
├── package.json                  # Node.js dependencies
├── package-lock.json             # Node.js lock file
├── analysis_options.yaml         # Dart analyzer config
├── firebase.json                 # Firebase config
├── devtools_options.yaml         # DevTools config
│
├── README.md                     # Main documentation
└── PROJECT_STRUCTURE.md          # This file
```

## Mô tả các thư mục chính

### `lib/`
Chứa toàn bộ source code Dart của ứng dụng, được tổ chức theo kiến trúc clean architecture:
- **base/**: Base classes và utilities dùng chung
- **core/**: Core initialization logic
- **configs/**: Configuration files
- **extensions/**: Extension methods cho các types
- **firebase/**: Firebase integration
- **model/**: Data models
- **networking/**: Network layer với API clients và interceptors
- **permission/**: Permission handling
- **preference/**: Local storage và preferences
- **resources/**: Resources như colors, styles, images
- **screen/**: UI screens (375+ files)
- **services/**: Business services
- **shared/**: Shared utilities
- **utils/**: Utility functions
- **web/**: Web-specific integration
- **widgets/**: Reusable widgets
- **deferred/**: Deferred loading
- **directional/**: Direction handling

### `assets/`
Chứa các assets tĩnh:
- **config/**: Environment configuration files
- **data/**: Static JSON data
- **icons/**: App icons theo từng environment (dev/pro/stg)
- **images/**: Images và icons (96 files)

### `web/`
Web assets cho Flutter web:
- **index.html**: Main HTML file
- **manifest.json**: PWA manifest
- **icons/**: PWA icons
- **js/**: JavaScript files (x-app-sdk loader)

### `android/` và `ios/`
Platform-specific code và configurations cho Android và iOS.

### `build/`
Thư mục build output (generated, không commit vào git).

### `web_dev_export_*/` và `web_prod_export_*/`
Thư mục export được tạo bởi `export_dev.sh` và `export_prod.sh`, chứa:
- Build output đã optimized
- Pre-compressed assets (.gz, .br)
- `serve_local.sh` script để test local

### Scripts
- `export_dev.sh`: Export development build
- `export_prod.sh`: Export production build
- `run_dev.sh`: Run development với CORS disabled
- `run_prod.sh`: Run production preview
- `run_dev_nginx.sh`: Build + Nginx setup (all-in-one)

