import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';
import '../../../app/routing/directional_action_type.dart';

part 'affiliate_product_top_sale_model.g.dart';
@JsonSerializable()
class AffiliateProductTopSaleModel {
  @JsonKey(name: 'product_name')
  final String? productName;
  @JsonKey(name: 'product_price')
  final String? productPrice;
  @JsonKey(name: 'product_link')
  final String? productLink;
  final String? commision;
  final String? logo;
  @JsonKey(name: 'thumnail_link')
  final String? thumnailLink;
  @JsonKey(name: 'quantity_sold')
  final String? quantitySold;
  final String? direction;

  DirectionalScreen? get direcionalScreen {
    if ((productLink ?? "").isEmpty) return null;
    if (direction == "IN-APP") {
      return DirectionalScreen.buildByName(
        name: DirectionalScreenName.viewDeepLinkInApp,
        clickActionParam: productLink,
      );
    }
    return DirectionalScreen.buildByName(
      name: DirectionalScreenName.viewDeepLink,
      clickActionParam: productLink,
    );
  }

  AffiliateProductTopSaleModel({
    this.productName,
    this.productPrice,
    this.productLink,
    this.commision,
    this.logo,
    this.thumnailLink,
    this.quantitySold,
    this.direction,
  });

  factory AffiliateProductTopSaleModel.fromJson(Map<String, dynamic> json) => _$AffiliateProductTopSaleModelFromJson(json);
  Map<String, dynamic> toJson() => _$AffiliateProductTopSaleModelToJson(this);
}
