import 'package:flutter/material.dart';
import 'models/affiliate_brand_detail_model.dart';

class AffiliateTagListScrollable extends StatelessWidget {
  final List<AffiliateBrandCategoryModel> items;

  const AffiliateTagListScrollable({super.key, required this.items});

  @override
  Widget build(BuildContext context) {
    int lines = 2;
    if (items.length > 20) {
      lines = 3;
    } else if (items.length < 10) {
      lines = 1;
    }

    const double tagHeight = 36;
    const double itemSpacing = 10;

    final double containerHeight =
        lines * tagHeight + (lines - 1) * itemSpacing;

    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        const Padding(
          padding: EdgeInsets.only(left: 16, bottom: 8),
          child: Text(
            "Tỉ lệ hoàn điểm",
            style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
          ),
        ),
        Padding(
          padding: EdgeInsets.only(left: 16, bottom: 0),
          child: SizedBox(
            height: containerHeight,
            child: SingleChildScrollView(
              scrollDirection: Axis.horizontal,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: List.generate(lines, (lineIndex) {
                  final lineItems = items
                      .skip(lineIndex * (items.length ~/ lines))
                      .take(items.length ~/ lines)
                      .toList();
                  return Padding(
                    padding: EdgeInsets.only(bottom: lineIndex < lines - 1 ? itemSpacing : 0),
                    child: Row(
                      children: lineItems.map((item) {
                        return Container(
                          margin: const EdgeInsets.only(right: itemSpacing),
                          padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 6),
                          decoration: BoxDecoration(
                            color: Colors.grey.shade200,
                            borderRadius: BorderRadius.circular(8),
                          ),
                          child: RichText(
                            text: TextSpan(
                              text: '${item.categoryName}: ',
                              style: const TextStyle(color: Colors.black87, fontSize: 14),
                              children: [
                                TextSpan(
                                  text: item.showCommision,
                                  style: const TextStyle(color: Colors.deepOrangeAccent, fontSize: 14),
                                ),
                              ],
                            ),
                          ),
                        );
                      }).toList(),
                    ),
                  );
                }),
              ),
            ),
          ),
        ),
      ],
    );
  }
}
