import 'package:json_annotation/json_annotation.dart';
import 'package:intl/intl.dart';
import '../../../shared/navigation/directional_screen.dart';

part 'hover_data_model.g.dart';
@JsonSerializable()
class HoverDataModel {
  final String? icon;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  final int? badge;
  final String? countdown;

  HoverDataModel({
    this.icon,
    this.clickActionType,
    this.clickActionParam,
    this.badge,
    this.countdown,
  });

  double? get countDownTime {
    if (countdown == null) return null;
    try {
      final date = DateFormat("yyyy-MM-dd HH:mm:ss").parseUtc(countdown!);
      final now = DateTime.now().toUtc();
      final diff = date.difference(now).inSeconds;
      return (diff > 0 ? diff : 0).toDouble();
    } catch (_) {
      return null;
    }
  }

  DirectionalScreen? get direction {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  factory HoverDataModel.fromJson(Map<String, dynamic> json) => _$HoverDataModelFromJson(json);
  Map<String, dynamic> toJson() => _$HoverDataModelToJson(this);
}
