import 'package:get/get.dart';
import 'package:mypoint_flutter_app/shared/widgets/base_view/base_response_model.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/features/create_pass/create_pass_screen.dart';
import 'package:mypoint_flutter_app/features/create_pass/reset_create_password_repository.dart';
import '../../core/network/restful_api_viewmodel.dart';
import 'otp_viewmodel.dart';

class ForgotPassOTPRepository extends RestfulApiViewModel implements IOtpRepository {
  ForgotPassOTPRepository(this.phoneNumber, this.otpTtl);

  @override
  int otpTtl;

  @override
  String phoneNumber;

  @override
  Future<int?> resendOtp() {
    throw UnimplementedError();
  }

  @override
  Future<void> sendOtp() {
    throw UnimplementedError();
  }

  @override
  Future<BaseResponseModel<EmptyCodable>> verifyOtp(String otpCode) {
    showLoading();
    return client.otpVerifyForDoingNextEvent(phoneNumber, otpCode, "RESET_PASSWORD").then((value) {
      hideLoading();
      if (value.status == "success" || value.code == 200) {
        Get.off(() => CreatePasswordScreen(repository: ResetCreatePasswordRepository(phoneNumber)));
      }
      return value;
    });
  }
}