import 'package:json_annotation/json_annotation.dart';

part 'brand_network_model.g.dart';
@JsonSerializable()
class BrandNetworkModel {
  final int? id;
  final int? stock;
  final String? code;
  final String? name;
  final String? logo;

  BrandNetworkModel({
    this.id,
    this.stock,
    this.code,
    this.name,
    this.logo,
  });

  factory BrandNetworkModel.fromJson(Map<String, dynamic> json) =>
      _$BrandNetworkModelFromJson(json);

  Map<String, dynamic> toJson() => _$BrandNetworkModelToJson(this);
}

@JsonSerializable()
class BrandNameCheckResponse {
  final String? brand;

  BrandNameCheckResponse({this.brand});

  factory BrandNameCheckResponse.fromJson(Map<String, dynamic> json) =>
      _$BrandNameCheckResponseFromJson(json);

  Map<String, dynamic> toJson() => _$BrandNameCheckResponseToJson(this);
}
