class OrderItemsProductResponse {
  final String? itemIds;
  final String? itemExpireTime;
  final String? productType;

  OrderItemsProductResponse({
    this.itemIds,
    this.itemExpireTime,
    this.productType,
  });

  factory OrderItemsProductResponse.fromJson(Map<String, dynamic> json) {
    return OrderItemsProductResponse(
      itemIds: json['item_ids'] as String?,
      itemExpireTime: json['item_expire_time'] as String?,
      productType: json['product_type'] as String?,
    );
  }

  Map<String, dynamic> toJson() => {
    'item_ids': itemIds,
    'item_expire_time': itemExpireTime,
    'product_type': productType,
  };
}
