import 'package:json_annotation/json_annotation.dart';
import 'order_items_product_payment_response_model.dart';

part 'order_product_payment_response_model.g.dart';
@JsonSerializable()
class OrderProductPaymentResponseModel {
  final String? id;
  @JsonKey(name: 'payment_method')
  final String? paymentMethod;
  @JsonKey(name: "payment_type")
  final String? paymentType;
  @JsonKey(name: "payment_partner")
  final String? paymentPartner;
  @JsonKey(name: "payment_url")
  final String? paymentUrl;
  @JsonKey(name: "request_id")
  final String? requestId;
  final List<OrderItemsProductResponse>? items;
  final int? subtotal;
  @JsonKey(name: "payment_transaction_id")
  final String? paymentTransactionId;
  @JsonKey(name: "created_at")
  final String? createdAt;

  OrderProductPaymentResponseModel({
    this.id,
    this.paymentMethod,
    this.paymentType,
    this.paymentPartner,
    this.paymentUrl,
    this.requestId,
    this.items,
    this.subtotal,
    this.paymentTransactionId,
    this.createdAt,
  });

  factory OrderProductPaymentResponseModel.fromJson(Map<String, dynamic> json) =>
      _$OrderProductPaymentResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$OrderProductPaymentResponseModelToJson(this);

  /// Custom Getter: redeemId
  String? get redeemId {
    final firstItemIds = items?.firstOrNull?.itemIds;
    return firstItemIds?.split(',').first;
  }

  /// Custom Getter: expireTime
  String? get expireTime {
    return items?.firstOrNull?.itemExpireTime;
  }
}
