import 'package:flutter/material.dart';
import 'package:get/get_state_manager/src/rx_flutter/rx_obx_widget.dart';
import 'package:mypoint_flutter_app/shared/direction_google_map.dart';
import '../models/product_store_model.dart';

class StoreListSection extends StatefulWidget {
  final List<ProductStoreModel> stores;
  final String? brandLogo;

  const StoreListSection({super.key, required this.stores, this.brandLogo});

  @override
  State<StoreListSection> createState() => _StoreListSectionState();
}

class _StoreListSectionState extends State<StoreListSection> {
  bool _seeAllStore = false;
  final int _numberOfStore = 4;
  List<ProductStoreModel> get displayStores {
    return _seeAllStore ? widget.stores : widget.stores.take(_numberOfStore).toList();
  }

  @override
  Widget build(BuildContext context) {
    return Obx(() {
      if (displayStores.isEmpty) {
        return const SizedBox.shrink();
      }
      return Container(
        margin: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
        padding: const EdgeInsets.all(16),
        decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            const Text('Địa điểm áp dụng:', style: TextStyle(fontWeight: FontWeight.bold, fontSize: 16)),
            const SizedBox(height: 10),
            ...displayStores.map(
              (store) => InkWell(
                onTap: () {
                  _onTapStore(store);
                },
                child: _buildStoreItem(store),
              ),
            ),
            if (widget.stores.length > _numberOfStore)
              GestureDetector(
                onTap: () {
                  setState(() {
                    _seeAllStore = !_seeAllStore;
                  });
                },
                child: Center(
                  child: Text(
                    _seeAllStore ? 'Thu gọn' : 'Xem tất cả',
                    style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 16, color: Colors.blueAccent),
                  ),
                ),
              ),
          ],
        ),
      );
    });
  }

  void _onTapStore(ProductStoreModel store) {
    showGoogleMap(lat: store.latitude, lng: store.longitude);
  }

  Widget _buildStoreItem(ProductStoreModel store) {
    return Padding(
      padding: const EdgeInsets.only(bottom: 12),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              ClipOval(
                child: Image.network(
                  widget.brandLogo ?? "",
                  width: 20,
                  height: 20,
                  fit: BoxFit.cover,
                  errorBuilder: (_, _, _) => Image.asset('assets/images/ic_logo.png', width: 20, height: 20),
                ),
              ),
              const SizedBox(width: 8),
              Expanded(
                child: Text(store.name ?? '', style: const TextStyle(fontWeight: FontWeight.w600), softWrap: true),
              ),
            ],
          ),
          const SizedBox(height: 4),
          if ((store.address ?? '').isNotEmpty)
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                const Icon(Icons.location_on_outlined, size: 18, color: Colors.grey),
                const SizedBox(width: 4),
                Expanded(
                  child: Text(
                    store.address ?? '',
                    style: const TextStyle(color: Colors.grey, fontSize: 13),
                    maxLines: 2,
                    overflow: TextOverflow.ellipsis,
                  ),
                ),
              ],
            ),
        ],
      ),
    );
  }
}
