import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/num_extension.dart';

part 'product_properties_model.g.dart';
@JsonSerializable()
class ProductPropertiesModel {
  @JsonKey(name: 'voucher_type')
  final String? voucherType;
  @JsonKey(name: 'voucher_value')
  final double? voucherValue;

  ProductPropertiesModel({this.voucherType, this.voucherValue});

  String? get title {
    if (voucherValue == null || voucherValue == 0) return null;
    if (voucherType == "VOUCHER_TYPE_DISCOUNT") {
      return "${voucherValue!.toStringAsFixed(0)}%";
    }
    return voucherValue!.money(CurrencyUnit.vnd);
  }

  factory ProductPropertiesModel.fromJson(Map<String, dynamic> json) => _$ProductPropertiesModelFromJson(json);
  Map<String, dynamic> toJson() => _$ProductPropertiesModelToJson(this);
}
