import 'package:barcode_widget/barcode_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:mypoint_flutter_app/shared/widgets/custom_navigation_bar.dart';
import 'package:mypoint_flutter_app/shared/widgets/custom_toast_message.dart';
import 'package:mypoint_flutter_app/shared/widgets/dashed_line.dart';
import 'package:qr_flutter/qr_flutter.dart';
import '../../app/config/constants.dart';
import '../../core/theme/base_color.dart';
import '../../shared/widgets/back_button.dart';
import '../../shared/widgets/custom_point_text_tag.dart';
import '../../shared/widgets/image_loader.dart';
import 'models/product_model.dart';

class VoucherCodeCardScreen extends StatelessWidget {
  final ProductModel product;

  const VoucherCodeCardScreen({super.key, required this.product});

  @override
  Widget build(BuildContext context) {
    final code = product.item?.codeSecret ?? '';
    final password = product.item?.password ?? "";
    final screenWidth = MediaQuery.of(context).size.width;
    final topExpand = MediaQuery.of(context).padding.top + 8 + Constants.extendTopPaddingNavigation;
    return Scaffold(
      backgroundColor: BaseColor.primary500,
      body: Stack(
        children: [
          Column(
            children: [
              Container(
                margin: EdgeInsets.only(left: 16, right: 16, top: 16 + topExpand + 36), //all(16),
                padding: const EdgeInsets.all(16),
                decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(16)),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Text(
                      product.name ?? '',
                      style: const TextStyle(fontSize: 24, fontWeight: FontWeight.bold),
                      textAlign: TextAlign.center,
                    ),
                    const SizedBox(height: 8),
                    if (product.expire.isNotEmpty)
                      Text.rich(
                        TextSpan(
                          children: [
                            const TextSpan(text: 'Hạn dùng: ', style: TextStyle(color: Colors.black87, fontSize: 14)),
                            TextSpan(
                              text: product.expire,
                              style: const TextStyle(
                                color: BaseColor.primary500,
                                fontWeight: FontWeight.bold,
                                fontSize: 14,
                              ),
                            ),
                          ],
                        ),
                      ),
                    const SizedBox(height: 8),
                    QrImageView(
                      data: code,
                      size: screenWidth / 2.2,
                      embeddedImage: const AssetImage('assets/images/ic_logo.png'),
                      embeddedImageStyle: QrEmbeddedImageStyle(size: Size(screenWidth/9, screenWidth/9)),
                    ),
                    const SizedBox(height: 8),
                    BarcodeWidget(
                      data: code,
                      barcode: Barcode.code128(),
                      height: 60,
                      width: screenWidth / 1.5,
                      drawText: false,
                    ),
                    const SizedBox(height: 12),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Text(code, style: const TextStyle(fontSize: 18, fontWeight: FontWeight.bold)),
                        const SizedBox(width: 8),
                        GestureDetector(
                          onTap: () {
                            Clipboard.setData(ClipboardData(text: code));
                            showToastMessage('Đã sao chép mã');
                          },
                          child: Container(
                            padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 4),
                            decoration: BoxDecoration(
                              border: Border.all(color: Colors.red),
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: const Text('Copy', style: TextStyle(color: Colors.red, fontWeight: FontWeight.w600)),
                          ),
                        ),
                      ],
                    ),
                    const SizedBox(height: 12),
                    if (password.isNotEmpty)
                      Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Text("Mật khẩu", style: const TextStyle(fontSize: 14, color: Colors.black54)),
                          const SizedBox(width: 8),
                          Text(password, style: const TextStyle(fontSize: 18, fontWeight: FontWeight.bold)),
                          const SizedBox(width: 8),
                          GestureDetector(
                            onTap: () {
                              Clipboard.setData(ClipboardData(text: password));
                              ScaffoldMessenger.of(
                                context,
                              ).showSnackBar(const SnackBar(content: Text('Đã sao chép mật khẩu')));
                            },
                            child: Container(
                              padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 4),
                              decoration: BoxDecoration(
                                border: Border.all(color: Colors.red),
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: const Text(
                                'Copy',
                                style: TextStyle(color: Colors.red, fontWeight: FontWeight.w600),
                              ),
                            ),
                          ),
                        ],
                      ),
                    DashedLine(),
                    const SizedBox(height: 12),
                    Row(
                      children: [
                        CircleAvatar(
                          radius: 12,
                          backgroundColor: Colors.transparent,
                          child: ClipOval(
                            child: loadNetworkImage(
                              url: product.brand?.logo ?? "",
                              width: 24,
                              height: 24,
                              fit: BoxFit.cover,
                              placeholderAsset: 'assets/images/ic_logo.png',
                            ),
                          ),
                        ),
                        const SizedBox(width: 8),
                        Expanded(child: Text(product.brand?.name ?? '', style: const TextStyle(fontSize: 14))),
                        CustomPointText(point: product.amountToBePaid ?? 0, type: product.price?.method),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
          Positioned(
            bottom: MediaQuery.of(context).padding.bottom + 8,
            left: 0,
            child: SizedBox(
              width: 200,
              height: 200,
              child: Image.asset('assets/images/ic_scan_tutorial.png', fit: BoxFit.cover),
            ),
          ),
          Positioned(top: topExpand, left: 8, child: CustomBackButton()),
        ],
      ),
    );
  }
}
