import 'package:flutter/material.dart';
import 'package:get/get.dart';

class BottomSheetHelper {
  static void showBottomSheetPopup({
    required Widget child,
    Color backgroundContainerColor = Colors.white,
    double horizontalContainerPadding = 8.0,
    double bottomContainerPadding = 16.0,
    bool isDismissible = true,
  }) {
    showModalBottomSheet(
      context: Get.context!,
      isScrollControlled: true,
      isDismissible: isDismissible,
      backgroundColor: Colors.transparent,
      barrierColor: Colors.black.withOpacity(0.7),
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(top: Radius.circular(16)),
      ),
      builder: (context) {
        return Padding(
          padding: MediaQuery.of(context).viewInsets.add(
            const EdgeInsets.only(bottom: 0), // 👈 Safe area bottom
          ),
          child: Wrap(
            children: [
              Container(
                decoration: BoxDecoration(
                  color: backgroundContainerColor,
                  borderRadius: const BorderRadius.vertical(top: Radius.circular(16)),
                ),
                padding: EdgeInsets.only(
                  left: horizontalContainerPadding,
                  right: horizontalContainerPadding,
                  bottom: bottomContainerPadding,
                ),
                child: child,
              ),
              SizedBox(height: 32,),
            ],
          ),
        );
      },
    );
  }
}