import 'package:flutter/foundation.dart';
import '../network/dio_http_service.dart';
import '../network/restful_api_client.dart';
import '../network/restful_api_client_all_request.dart';
import '../../shared/preferences/data_preference.dart';

class LogoutService {
  LogoutService._();
  static final RestfulAPIClient _client = RestfulAPIClient(DioHttpService().dio);
  static Future<void> logout() async {
    if (!DataPreference.instance.logged) return;
    try {
      await _client.logout();
    } catch (e) {
      debugPrint('LogoutService.logout failed: $e');
    }
  }
}
