import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/features/create_pass/signup_create_password_repository.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import 'package:mypoint_flutter_app/shared/widgets/custom_toast_message.dart';
import '../../shared/widgets/base_view/base_response_model.dart';
import '../../core/network/restful_api_viewmodel.dart';

class ResetCreatePasswordRepository extends RestfulApiViewModel implements ICreatePasswordRepository {
  @override
  late String phoneNumber;

  ResetCreatePasswordRepository(this.phoneNumber);

  @override
  Future<BaseResponseModel<EmptyCodable>> setPassword(String password) async {
    showLoading();
    return client.accountPasswordReset(phoneNumber, password).then((value) {
      hideLoading();
      if (value.status == "success" || value.code == 200) {
        Get.offNamed(loginScreen, arguments: {'phone': phoneNumber, 'password': password});
        showToastMessage("Đặt lại mật khẩu thành công.");
      }
      return value;
    });
  }
}
