import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/num_extension.dart';
import 'package:mypoint_flutter_app/shared/widgets/image_loader.dart';
import '../../../shared/preferences/data_preference.dart';
import '../../../shared/preferences/point/point_manager.dart';
import '../../../shared/router_gage.dart';
import '../models/header_home_model.dart';
import '../../notification/models/notification_unread_model.dart';

class HomeGreetingHeader extends StatelessWidget {
  final double? heightContent;
  HeaderHomeModel dataHeader;
  NotificationUnreadData? notificationUnreadData;

  HomeGreetingHeader({super.key, this.heightContent, required this.dataHeader, required this.notificationUnreadData});

  @override
  Widget build(BuildContext context) {
    final width = MediaQuery.of(context).size.width;
    final heightSize = heightContent ?? (width * 86 / 375 + 112);
    final name = DataPreference.instance.displayName;
    final level = DataPreference.instance.rankName ?? "Hạng Đồng";
    final double heightWhiteBox = 112;

    return Stack(
      children: [
        Container(
          color: Colors.black,
          height: heightSize,
          width: double.infinity,
          child: Align(
            alignment: Alignment.topCenter,
            child: SizedBox(
              height: 44 + kToolbarHeight + 20,
              width: double.infinity,
              child: loadNetworkImage(
                url: dataHeader.background,
                fit: BoxFit.cover,
                placeholderAsset: "assets/images/bg_header_navi.png",
              ),
            ),
          ),
        ),
        Positioned(
          bottom: heightWhiteBox + 16,
          left: 16,
          child: Image.asset('assets/images/ic_logo_mypoint.png', height: 24),
        ),
        Positioned(
          left: 0,
          right: 0,
          bottom: 0,
          child: Container(
            height: heightWhiteBox,
            padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.only(
                topRight: Radius.circular(16),
                topLeft: Radius.circular(16),
              ), //.circular(20),
            ),
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(
                      'Xin chào $name!',
                      style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold, color: Colors.black87),
                    ),
                    Row(
                      children: [
                        GestureDetector(
                          onTap: _onSearchTap,
                          child: Container(
                            padding: EdgeInsets.all(8),
                            child: Image.asset('assets/images/ic_search_black.png', width: 32, height: 32),
                          ),
                        ),
                        GestureDetector(
                          onTap: _onNotificationTap,
                          child: Container(
                            padding: EdgeInsets.all(8),
                            child: Stack(
                              children: [
                                Image.asset('assets/images/ic_notify_black.png', width: 32, height: 32),
                                if ((notificationUnreadData?.unread ?? 0) > 0)
                                  Positioned(
                                    right: 6,
                                    top: 4,
                                    child: Container(
                                      height: 8,
                                      width: 8,
                                      decoration: BoxDecoration(color: Colors.red, shape: BoxShape.circle),
                                    ),
                                  ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
                const SizedBox(height: 2),
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    Obx(() {
                      final point = UserPointManager().pointStream.value;
                      return _buildStatItem(
                        icon: "assets/images/ic_point_gray.png",
                        value: point.money(CurrencyUnit.none),
                        onTap: _onPointTap,
                      );
                    }),
                    const SizedBox(width: 8),
                    _buildStatItem(
                      icon: "assets/images/ic_voucher_gray.png",
                      value: dataHeader.totalVoucher.toString(),
                      onTap: _onMyVoucherTap,
                    ),
                    const SizedBox(width: 8),
                    _buildStatItem(icon: "assets/images/ic_rank_gray.png", value: level, onTap: _onRankTap),
                  ],
                ),
              ],
            ),
          ),
        ),
      ],
    );
  }

  Widget _buildStatItem({required String icon, required String value, VoidCallback? onTap}) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 12, vertical: 4),
        decoration: BoxDecoration(borderRadius: BorderRadius.circular(20), border: Border.all(color: Colors.black26)),
        child: Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            Container(padding: EdgeInsets.all(2), child: Image.asset(icon, width: 24, height: 24)),
            SizedBox(width: 2),
            Text(value, style: TextStyle(fontSize: 14, fontWeight: FontWeight.w500, color: Colors.black87)),
          ],
        ),
      ),
    );
  }

  void _onSearchTap() {
    Get.toNamed(vouchersScreen, arguments: {"enableSearch": true});
  }

  void _onNotificationTap() {
    Get.toNamed(notificationScreen);
  }

  void _onPointTap() {
    Get.toNamed(historyPointScreen);
  }

  void _onMyVoucherTap() {
    Get.toNamed(myVoucherListScreen);
  }

  void _onRankTap() {
    Get.toNamed(membershipScreen);
  }
}
