import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';

part 'main_service_model.g.dart';
@JsonSerializable()
class MainServiceModel {
  @JsonKey(name: 'service_name')
  final String? serviceName;
  @JsonKey(name: 'service_icon')
  final String? serviceIcon;
  @JsonKey(name: 'image_url')
  final String? imageUrl;
  @JsonKey(name: 'click_action_type')
  final String? clickActionType;
  @JsonKey(name: 'click_action_param')
  final String? clickActionParam;
  @JsonKey(name: 'event_describle')
  final String? eventDescrible;
  @JsonKey(name: 'event_color')
  final String? eventColor;
  @JsonKey(name: 'service_code')
  final String? serviceCode;

  const MainServiceModel({
    this.serviceName,
    this.serviceIcon,
    this.imageUrl,
    this.clickActionType,
    this.clickActionParam,
    this.eventDescrible,
    this.eventColor,
    this.serviceCode,
  });

  DirectionalScreen? get directionalScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }
  factory MainServiceModel.fromJson(Map<String, dynamic> json) =>
      _$MainServiceModelFromJson(json);
  Map<String, dynamic> toJson() => _$MainServiceModelToJson(this);
}
