import 'package:json_annotation/json_annotation.dart';
import 'cash_type.dart'; // Enum CashType

part 'product_price_model.g.dart';
@JsonSerializable()
class ProductPriceModel {
  @JsonKey(name: "payment_method")
  final String? paymentMethod;
  @JsonKey(name: "sale_price")
  final int? salePrice;
  @JsonKey(name: "last_price")
  final int? lastPrice;

  ProductPriceModel({
    this.paymentMethod,
    this.salePrice,
    this.lastPrice,
  });

  CashType get method => CashTypeExt.from(paymentMethod);
  int? get value => lastPrice ?? salePrice;

  factory ProductPriceModel.fromJson(Map<String, dynamic> json) => _$ProductPriceModelFromJson(json);
  Map<String, dynamic> toJson() => _$ProductPriceModelToJson(this);
}
