import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/color_extension.dart';
import 'package:mypoint_flutter_app/core/utils/extensions/string_extension.dart';
import '../../navigation/directional_screen.dart';
import 'data_alert_model.dart';

part 'button_config_model.g.dart';
@JsonSerializable()
class ButtonConfigModel {
  final String? text;
  final String? color;
  @JsonKey(name: "click_action_type")
  final String? clickActionType;
  @JsonKey(name: "click_action_param")
  final String? clickActionParam;

  ButtonConfigModel({this.text, this.color, this.clickActionType, this.clickActionParam});

  AlertButton get alertButton {
    final bgColor = color?.toColor() ?? Colors.white;
    return AlertButton(
      text: text ?? "",
      textColor: bgColor.contrastTextColor,
      bgColor: bgColor,
      onPressed: () async {
        DirectionalScreen? directional = DirectionalScreen.build(
          clickActionType: clickActionType,
          clickActionParam: clickActionParam,
        );
        Get.back();
        directional?.begin();
      },
    );
  }

  factory ButtonConfigModel.fromJson(Map<String, dynamic> json) => _$ButtonConfigModelFromJson(json);
  Map<String, dynamic> toJson() => _$ButtonConfigModelToJson(this);
}
