# Simple Setup Guide

## ✅ Đã dọn dẹp xong!

### 🗑️ **Đã xóa:**
- Tất cả config môi trường phức tạp (`env_web_dev.json`, `env_web_stg.json`, `env_web_prod.json`)
- Các script export phức tạp (`export_web_dev.sh`, `export_web_stg.sh`, `export_web_prod.sh`)
- Script export tất cả môi trường (`export_all_envs.sh`)
- File hướng dẫn phức tạp (`ENVIRONMENT_CONFIG.md`)

### ✅ **Còn lại (đơn giản):**

#### **1. Config duy nhất:**
- `assets/config/env.json` - Config chính cho tất cả môi trường

#### **2. Scripts chính:**
- `./export_web.sh` - Export web app (đơn giản)
- `./scripts/run_web_complete.sh` - Chạy development với CORS
- `./scripts/export_and_run.sh` - Export + chạy + mở browser


## 🚀 **Cách sử dụng đơn giản:**

### **Development (chạy local):**
```bash
./run_dev.sh
```

### **Export Development (để test trên server):**
```bash
./export_dev.sh
```

### **Export Production:**
```bash
./run_prod.sh
```

### **Chuyển đổi môi trường thủ công:**
```bash
# Chuyển sang Development
./scripts/switch_env.sh dev

# Chuyển sang Production  
./scripts/switch_env.sh prod
```

## ⚠️ **Vấn đề CORS:**

### **Lỗi thường gặp:**
```
Access to XMLHttpRequest at 'https://api.sandbox.mypoint.com.vn/...' 
from origin 'http://localhost:8080' has been blocked by CORS policy
```

### **Nguyên nhân:**
- API server chỉ cho phép origin `https://api.evnpoint.com`
- Web app chạy trên `http://localhost:8080`
- Đây là vấn đề **server-side**, không phải client-side

### **Giải pháp:**
1. **Chrome với CORS disabled** (Khuyến nghị):
   ```bash
   ./scripts/open_chrome_cors_disabled.sh
   ```

2. **Script tự động**:
   ```bash
   ./scripts/run_web_cors_fixed.sh
   ```

3. **CORS Browser Extension**:
   - Cài "CORS Unblock" extension
   - Enable khi test


## 📁 **Cấu trúc đơn giản:**

```
flutter_app_mypoint/
├── assets/config/
│   └── env.json                    # Config duy nhất
├── lib/web/
│   └── (web helper files)
├── web/
│   └── index.html                  # JavaScript integration
├── export_web.sh                   # Export script
└── scripts/
    ├── run_web_complete.sh         # Development
    ├── export_and_run.sh           # Export + run
    └── test_web.sh                 # Test web
```

## 🎯 **Kết quả:**
- ✅ **Đơn giản**: Chỉ 1 config file
- ✅ **Dễ hiểu**: Không còn phức tạp
- ✅ **Web**: Tích hợp đầy đủ
- ✅ **Sẵn sàng**: Export và deploy ngay
