import '../../../configs/callbacks.dart';

class TransactionSummaryByDateModel {
  final MonthSummaryChartModel month;
  final List<DaySummaryChartModel> days;

  const TransactionSummaryByDateModel({
    required this.month,
    required this.days,
  });

  factory TransactionSummaryByDateModel.fromJson(Json json) {
    return TransactionSummaryByDateModel(
      month: MonthSummaryChartModel.fromJson((json['month'] as Json?) ?? const {}),
      days: ((json['days'] as List?) ?? const [])
          .map((e) => DaySummaryChartModel.fromJson(e as Json))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() => {
    'month': month.toJson(),
    'days': days.map((e) => e.toJson()).toList(),
  };
}

class DaySummaryChartModel {
  final String? summaryDate;
  final String? adjustDayTotal;
  final String? redeemDayTotal;
  final String? rewardDayTotal;

  const DaySummaryChartModel({
    this.summaryDate,
    this.adjustDayTotal,
    this.redeemDayTotal,
    this.rewardDayTotal,
  });

  factory DaySummaryChartModel.fromJson(Json json) {
    return DaySummaryChartModel(
      summaryDate: json['summary_date'] as String?,
      adjustDayTotal: json['adjust_day_total'] as String?,
      redeemDayTotal: json['redeem_day_total'] as String?,
      rewardDayTotal: json['reward_day_total'] as String?,
    );
  }

  Map<String, dynamic> toJson() => {
    'summary_date': summaryDate,
    'adjust_day_total': adjustDayTotal,
    'redeem_day_total': redeemDayTotal,
    'reward_day_total': rewardDayTotal,
  };
}

class MonthSummaryChartModel {
  final String? adjustMonthTotal;
  final String? redeemMonthTotal;
  final String? rewardMonthTotal;

  const MonthSummaryChartModel({
    this.adjustMonthTotal,
    this.redeemMonthTotal,
    this.rewardMonthTotal,
  });

  factory MonthSummaryChartModel.fromJson(Json json) {
    return MonthSummaryChartModel(
      adjustMonthTotal: json['adjust_month_total'] as String?,
      redeemMonthTotal: json['redeem_month_total'] as String?,
      rewardMonthTotal: json['reward_month_total'] as String?,
    );
  }

  Map<String, dynamic> toJson() => {
    'adjust_month_total': adjustMonthTotal,
    'redeem_month_total': redeemMonthTotal,
    'reward_month_total': rewardMonthTotal,
  };
}