
import 'package:json_annotation/json_annotation.dart';

part 'accumulated_counter_model.g.dart';
@JsonSerializable()
class AccumulatedCounter {
  @JsonKey(name: 'what_to_count_code')
  final String? whatToCountCode;
  @JsonKey(name: 'what_to_count_name')
  final String? whatToCountName;
  @JsonKey(name: 'counter_value')
  final String? counterValue;
  @JsonKey(name: 'counter_point_value')
  final String? couterPointValue;
  @JsonKey(name: 'counter_gmv_value')
  final String? couterGmvValue;

  AccumulatedCounter({
    this.whatToCountCode,
    this.whatToCountName,
    this.counterValue,
    this.couterPointValue,
    this.couterGmvValue,
  });

  String get counterValueDisplay {
    final amount = int.tryParse(counterValue ?? '') ?? 0;
    return amount.toString().replaceAllMapped(RegExp(r'\B(?=(\d{3})+(?!\d))'), (match) => ',');
  }

  factory AccumulatedCounter.fromJson(Map<String, dynamic> json) =>
      _$AccumulatedCounterFromJson(json);
  Map<String, dynamic> toJson() => _$AccumulatedCounterToJson(this);
}
