import 'package:flutter/foundation.dart';
import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/screen/mobile_card/models/product_mobile_card_model.dart';

import '../../home/models/brand_model.dart';

part 'usable_voucher_model.g.dart';
@JsonSerializable()
class UsableVoucherModel {
  @JsonKey(name: 'voucher_id')
  final String? voucherID;
  @JsonKey(name: 'product_item_id')
  final String? voucherItemID;
  @JsonKey(name: 'action_time')
  final String? actionTime;
  final String? code;
  final String? serial;
  String? name;
  String? description;
  @JsonKey(name: 'voucher_type_code')
  final String? voucherTypeCode;
  @JsonKey(name: 'voucher_type_name')
  final String? voucherTypeName;
  @JsonKey(name: 'voucher_value')
  final String? voucherValue;
  @JsonKey(name: 'content')
  final String? voucherContent;
  @JsonKey(name: 'term_and_condition')
  final String? voucherTermAndCondition;
  @JsonKey(name: 'voucher_stock_remark')
  final String? voucherStockRemark;
  @JsonKey(name: 'expired_time')
  final String? expiredTime;
  @JsonKey(name: 'status_code')
  final String? statusCode;
  final String? status;
  @JsonKey(name: 'beneficiary_site_name')
  final String? beneficiarySiteName;

  final List<MobileCardPriceModel>? prices;
  final List<MobileCardImageModel>? images;
  final BrandModel? brand;

  @JsonKey(name: 'like_id')
  final String? likeId;
  @JsonKey(name: 'code_secret')
  String? codeSecret;
  final String? password;

  UsableVoucherModel({
    this.voucherID,
    this.voucherItemID,
    this.actionTime,
    this.code,
    this.serial,
    this.name,
    this.description,
    this.voucherTypeCode,
    this.voucherTypeName,
    this.voucherValue,
    this.voucherContent,
    this.voucherTermAndCondition,
    this.voucherStockRemark,
    this.expiredTime,
    this.statusCode,
    this.status,
    this.beneficiarySiteName,
    this.prices,
    this.images,
    this.brand,
    this.likeId,
    this.codeSecret,
    this.password,
  });

  factory UsableVoucherModel.fromJson(Map<String, dynamic> json) =>
      _$UsableVoucherModelFromJson(json);
  Map<String, dynamic> toJson() => _$UsableVoucherModelToJson(this);
}

@JsonSerializable()
class RedeemProductResponseModel {
  final UsableVoucherModel? item;

  RedeemProductResponseModel({this.item});

  factory RedeemProductResponseModel.fromJson(Map<String, dynamic> json) =>
      _$RedeemProductResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$RedeemProductResponseModelToJson(this);
}
