import 'package:json_annotation/json_annotation.dart';

part 'check_update_response_model.g.dart';
enum UpdateStatus { force, suggest, none }

@JsonSerializable()
class CheckUpdateResponseModel {
  @JsonKey(name: 'update_mode')
  String? updateMode;
  @JsonKey(name: 'update_title')
  String? updateTitle;
  @JsonKey(name: 'update_message')
  String? updateMessage;
  @JsonKey(name: 'update_link')
  String? updateLink;

  UpdateStatus get status {
    switch (updateMode?.toUpperCase() ?? "") {
      case 'NOW':
        return UpdateStatus.force;
      case 'NONE':
        return UpdateStatus.none;
      default:
        return UpdateStatus.suggest;
    }
  }

  CheckUpdateResponseModel({
    this.updateMode,
    this.updateTitle,
    this.updateMessage,
    this.updateLink,
  });

  factory CheckUpdateResponseModel.fromJson(Map<String, dynamic> json) => _$CheckUpdateResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$CheckUpdateResponseModelToJson(this);
}

