import 'dart:convert';
import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/screen/support/support_item_model.dart';

class SupportViewModel extends GetxController {
  var supportItems = <SupportItemModel>[].obs;

  @override
  void onInit() {
    super.onInit();
    loadSupportData();
  }

  Future<void> loadSupportData() async {
    try {
      final String response = await rootBundle.loadString('assets/data/support_data.json');
      final Map<String, dynamic> data = json.decode(response);
      final List<dynamic> items = data["data"]["items"];

      supportItems.value = items.map((item) => SupportItemModel.fromJson(item)).toList();
    } catch (e) {
      debugPrint("Lỗi load dữ liệu: $e");
    }
  }
}
