import { type ITerminalChunk } from './ITerminalChunk';
import { TerminalWritable } from './TerminalWritable';
/**
 * A {@link TerminalWritable} subclass that writes its output directly to the process `stdout` and `stderr`
 * streams.
 *
 * @remarks
 * This is the standard output target for a process.  You normally do not need to construct
 * this class; the {@link StdioWritable."instance"} singleton can be used instead.
 *
 * @public
 */
export declare class StdioWritable extends TerminalWritable {
    static instance: StdioWritable;
    protected onWriteChunk(chunk: ITerminalChunk): void;
}
//# sourceMappingURL=StdioWritable.d.ts.map