import 'package:json_annotation/json_annotation.dart';
part 'base_response_model.g.dart';

@JsonSerializable(genericArgumentFactories: true)
class BaseResponseModel<T> {
  final int? code;
  final String? status;
  @JsonKey(name: "error_message")
  final String? errorMessage;
  @JsonKey(name: "error_code")
  final String? errorCode;
  final String? message;
  final T? data;

  bool get isSuccess {
    final _code = code ?? 0;
    if (_code >= 200 && _code < 299) return true;
    return status?.toUpperCase() == "SUCCESS";
  }

  const BaseResponseModel({this.code, this.status, this.errorMessage, this.errorCode, this.message, this.data});

  factory BaseResponseModel.fromJson(Map<String, dynamic> json, T Function(Object? json) fromJsonT) {
    return _$BaseResponseModelFromJson<T>(json, fromJsonT);
  }
  Map<String, dynamic> toJson(Object? Function(T value) toJsonT) => _$BaseResponseModelToJson<T>(this, toJsonT);
}