import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/networking/restful_api_viewmodel.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';

class PushTokenService extends RestfulApiViewModel {
  static final PushTokenService _instance = PushTokenService._internal();
  PushTokenService._internal();
  factory PushTokenService() => _instance;

  static Future<void> uploadIfLogged({String? fcmToken}) async {
    final isLogged = DataPreference.instance.logged;
    if (!isLogged) return;
    final token = fcmToken ?? await FirebaseMessaging.instance.getToken();
    if (token == null || token.isEmpty) return;
    await _instance.client.pushNotificationDeviceUpdateToken(token);
  }
}
