#!/bin/bash

# Script to copy icons for different flavors
# This script copies the appropriate icon files to the Android res directories

echo "Copying icons for different flavors..."

# Function to copy icons for a specific flavor
copy_icons_for_flavor() {
    local flavor=$1
    local source_dir="assets/icons/$flavor"
    local target_dir="android/app/src/$flavor/res"
    
    echo "Copying icons for flavor: $flavor"
    
    # Create target directory if it doesn't exist
    mkdir -p "$target_dir/mipmap-hdpi"
    mkdir -p "$target_dir/mipmap-mdpi"
    mkdir -p "$target_dir/mipmap-xhdpi"
    mkdir -p "$target_dir/mipmap-xxhdpi"
    mkdir -p "$target_dir/mipmap-xxxhdpi"
    mkdir -p "$target_dir/drawable-hdpi"
    mkdir -p "$target_dir/drawable-mdpi"
    mkdir -p "$target_dir/drawable-xhdpi"
    mkdir -p "$target_dir/drawable-xxhdpi"
    mkdir -p "$target_dir/drawable-xxxhdpi"
    mkdir -p "$target_dir/values"
    
    # Copy app icon (you'll need to create different sizes)
    if [ -f "$source_dir/app_icon.png" ]; then
        cp "$source_dir/app_icon.png" "$target_dir/mipmap-hdpi/ic_launcher.png"
        cp "$source_dir/app_icon.png" "$target_dir/mipmap-mdpi/ic_launcher.png"
        cp "$source_dir/app_icon.png" "$target_dir/mipmap-xhdpi/ic_launcher.png"
        cp "$source_dir/app_icon.png" "$target_dir/mipmap-xxhdpi/ic_launcher.png"
        cp "$source_dir/app_icon.png" "$target_dir/mipmap-xxxhdpi/ic_launcher.png"
    fi
    
    # Copy foreground icon
    if [ -f "$source_dir/ic_foreground.png" ]; then
        cp "$source_dir/ic_foreground.png" "$target_dir/drawable-hdpi/ic_launcher_foreground.png"
        cp "$source_dir/ic_foreground.png" "$target_dir/drawable-mdpi/ic_launcher_foreground.png"
        cp "$source_dir/ic_foreground.png" "$target_dir/drawable-xhdpi/ic_launcher_foreground.png"
        cp "$source_dir/ic_foreground.png" "$target_dir/drawable-xxhdpi/ic_launcher_foreground.png"
        cp "$source_dir/ic_foreground.png" "$target_dir/drawable-xxxhdpi/ic_launcher_foreground.png"
    fi
    
    # Create colors.xml for this flavor
    case $flavor in
        "dev")
            echo '<?xml version="1.0" encoding="utf-8"?>
<resources>
    <color name="ic_launcher_background">#FEE440</color>
</resources>' > "$target_dir/values/colors.xml"
            ;;
        "stg")
            echo '<?xml version="1.0" encoding="utf-8"?>
<resources>
    <color name="ic_launcher_background">#E0E0E0</color>
</resources>' > "$target_dir/values/colors.xml"
            ;;
        "pro")
            echo '<?xml version="1.0" encoding="utf-8"?>
<resources>
    <color name="ic_launcher_background">#FFFFFF</color>
</resources>' > "$target_dir/values/colors.xml"
            ;;
    esac
    
    echo "Icons copied for $flavor"
}

# Copy icons for each flavor
copy_icons_for_flavor "dev"
copy_icons_for_flavor "stg"
copy_icons_for_flavor "pro"

echo "Icon copying completed!"

