
import 'package:flutter/material.dart';
import 'base_screen.dart';

mixin BasicState<Screen extends BaseScreen> on BaseState<Screen> {
  final GlobalKey<ScaffoldState> _scaffoldStateKey =
  GlobalKey(debugLabel: "BasicState");

  @override
  Widget build(BuildContext context) {
    var appBar = createAppBar();
    if (numberTabController > 0) {
      return DefaultTabController(
        length: numberTabController,
        child: WillPopScope(
          child: Scaffold(
            backgroundColor: colorView,
            key: _scaffoldStateKey,
            appBar: appBar,
            bottomNavigationBar: createBottomBar(),
            body: isSafeArea == true
                ? Container(
                color: colorSafeArea,
                child: SafeArea(
                    left: false, right: false, child: createBody()))
                : createBody(),
          ),
          onWillPop: () {
            callBackView();
            return willPopToPreviousScreen();
          },
        ),
      );
    }
    if (!isScaffold) {
      return PopScope(
        //   onWillPop: () {
        //   callBackView();
        //   return willPopToPreviousScreen();
        // },
          child: createBody());
    }
    return WillPopScope(
      child: Scaffold(
        backgroundColor: colorView,
        appBar: appBar,
        bottomNavigationBar: createBottomBar(),
        body: isSafeArea == true
            ? GestureDetector(
            onPanUpdate: (details) {
              // Swiping in right direction.
              if (details.delta.dx > 0) {
                // Get.back();
              }

              // Swiping in left direction.
              if (details.delta.dx < 0) {}
            },
            onTap: () {
              FocusScope.of(context).unfocus();
            },
            child: Container(
                color: colorSafeArea,
                child: SafeArea(
                    left: false,
                    right: false,
                    top: isTopSafeArea,
                    bottom: isBottomSafeArea,
                    child: createBody())))
            : GestureDetector(
            onPanUpdate: (details) {
              // Swiping in right direction.
              if (details.delta.dx > 0) {
                // Get.back();
              }

              // Swiping in left direction.
              if (details.delta.dx < 0) {
                // Get.back();
              }
            },
            onTap: () {
              FocusScope.of(context).unfocus();
            },
            child: createBody()),
      ),
      onWillPop: () {
        return willPopToPreviousScreen();
      },
    );
  }

  bool get isSafeArea {
    return false;
  }

  Color get colorView {
    return Colors.white;
  }

  bool get isScaffold {
    return true;
  }

  bool get isBottomSafeArea {
    return true;
  }

  bool get isTopSafeArea {
    return true;
  }

  Color get colorSafeArea {
    return Colors.white;
  }

  int get numberTabController {
    return 0;
  }

  Widget createBody();

  PreferredSizeWidget? createAppBar() {
    return null;
  }

  Future<bool> willPopToPreviousScreen() {
    return Future(() => true);
  }

  void callBackView() {}
}