import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_core/src/get_main.dart';
import 'package:mypoint_flutter_app/resouce/base_color.dart';

import '../configs/callbacks.dart';
import '../resouce/text_style.dart';
import '../widgets/button_container.dart';

extension BuildContextAndAlert on BuildContext {
  showAlertDialog(String message, {Callback<bool>? callback}) {
    _showConfirmAlertDialogTwoButton(message, callback: callback);
  }

  showConfirmAlertDialog(String message,
      {String cancel = "Huỷ",
        String confirm = "Xác nhận",
        Callback<bool>? callback}) {
    _showConfirmAlertDialogTwoButton(message, cancel: cancel, confirm: confirm, callback: callback);
  }

  _showConfirmAlertDialogTwoButton(String message,
      {String cancel = "",
        String confirm = "Xác nhận",
        Callback<bool>? callback}) {
    showDialog<void>(
      context: this,
      builder: (BuildContext context) {
        return AlertDialog(
            backgroundColor: Colors.white,
            title: Text('Thông báo',
                textAlign: TextAlign.center,
                style: textSemiBold.copyWith(fontSize: 16)),
            content: SingleChildScrollView(
                child: ListBody(children: [
                  Text(message),
                ])),
            actionsAlignment: MainAxisAlignment.center,
            actionsPadding: EdgeInsets.symmetric(horizontal: 20).copyWith(bottom: 20),
            actions: [
              ButtonContainer(
                  height: 40,
                  color: BaseColor.primary500,
                  visible: cancel.isNotEmpty,
                  child: TextButton(
                      child: Text(cancel,
                          style: textSemiBold.copyWith(
                              fontSize: 14, color: Colors.white)),
                      onPressed: () {
                        Get.back();
                        if (callback != null) {
                          callback(false);
                        }
                      })),
              ButtonContainer(
                  height: 40,
                  color: BaseColor.primary500,
                  visible: confirm.isNotEmpty,
                  child: TextButton(
                      child: Text(confirm,
                          style: textSemiBold.copyWith(
                              fontSize: 14, color: Colors.white)),
                      onPressed: () {
                        Get.back();
                        if (callback != null) {
                          callback(true);
                        }
                      }))
            ]);
      },
    );
  }
}