import 'dart:convert';
import 'package:crypto/crypto.dart';
import 'package:flutter/material.dart';

extension PhoneValidator on String {
  bool isPhoneValid() {
    return RegExp(r'^0\d{9}$').hasMatch(this);
  }
}

extension StringConvert on String {
  String toSha256() {
    var bytes1 = utf8.encode(this);
    var digest1 = sha256.convert(bytes1);
    return digest1.toString();
  }
}

/// Hàm parse hex -> Color
Color parseHexColor(String hexString, {Color fallbackColor = Colors.grey}) {
  try {
    if (hexString.startsWith('#')) {
      hexString = hexString.replaceFirst('#', '');
    }
    if (hexString.length == 6) {
      hexString = 'ff$hexString';
    }
    return Color(int.parse(hexString, radix: 16));
  } catch (e) {
    return fallbackColor;
  }
}
