import 'dart:io';

import 'package:dio/dio.dart';
import 'package:mypoint_flutter_app/configs/api_paths.dart';
import 'package:mypoint_flutter_app/model/check_update_response_model.dart';
import 'package:mypoint_flutter_app/networking/request_manager.dart';

class ApiService {
  final RequestManager _requestManager = RequestManager();

  Future<CheckUpdateResponseModel?> checkUpdateWithRequestManager() async {
    String version = Platform.version;
    try {
      Map<String, String> params = {
        "operating_system": "iOS",
        "software_model": "MyPoint",
        "version": version,
        "build_number": "1",
      };
      final response = await _requestManager.request(method: 'POST', path: APIPaths.checkUpdate);
      return CheckUpdateResponseModel.fromJson(response.data);
    } catch (e) {
      throw Exception('Failed to check update');
    }
  }
}

