
typedef Json = Map<String, dynamic>;

abstract class Encodable {
  Json toJson();
}

abstract class Fillable extends Encodable {
  void fill(Json data);
}

extension JsonEncode on Json {
  Json toJson() {
    return this;
  }
}

class ModelMaker {
  static T? makeFrom<T extends Encodable>(dynamic json) {
    try {
      switch (T) {
        // case WorkerSiteResponse: return WorkerSiteResponse.fromJson(json as Json) as T;
        // case LoginResponse: return LoginResponse.fromJson(json as Json) as T;
        default: return null;
      }
    } catch (e) {
      print("API ERROR parser: ${e.toString()}");
      return null;
    }
  }
}

extension L on List {

}