import 'dart:io';
import 'package:mypoint_flutter_app/configs/api_paths.dart';
import 'package:mypoint_flutter_app/base/base_response_model.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/extensions/string_extension.dart';
import 'package:mypoint_flutter_app/networking/restful_api.dart';
import '../configs/device_info.dart';
import '../model/update_response_object.dart';
import '../screen/onboarding/model/check_phone_response_model.dart';
import '../screen/onboarding/model/onboarding_info_model.dart';
import '../screen/otp/model/otp_verify_response_model.dart';
import '../screen/pageDetail/model/campaign_detail_model.dart';
import '../screen/pageDetail/model/detail_page_rule_type.dart';
import '../screen/splash/splash_screen_viewmodel.dart';
import 'model_maker.dart';

extension RestfullAPIClientAllApi on RestfulAPIClient {
  Future<BaseResponseModel<UpdateResponseObject>> checkUpdateApp() async {
    String version = Platform.version;
    final body = {"operating_system": "iOS", "software_model": "MyPoint", "version": version, "build_number": "1"};
    return requestNormal(
      APIPaths.checkUpdate,
      Method.POST,
      body,
      (data) => UpdateResponseObject.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<OnboardingInfoModel>> getOnboardingInfo() async {
    return requestNormal(
      APIPaths.getOnboardingInfo,
      Method.GET,
      {},
      (data) => OnboardingInfoModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<CheckPhoneResponseModel>> checkPhoneNumber(String phone) async {
    var deviceKey = await DeviceInfo.getDeviceId();
    var key = "$phone+_=$deviceKey/*8854";
    final body = {"device_key": deviceKey, "phone_number": phone, "key": key.toSha256()};
    return requestNormal(
      APIPaths.checkPhoneNumber,
      Method.POST,
      body,
      (data) => CheckPhoneResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<OTPVerifyResponseModel>> verifyOTP(String otp, String mfaToken) async {
    final body = {"otp": otp, "mfaToken": mfaToken,};
    return requestNormal(
      APIPaths.verifyOtpWithAction,
      Method.POST,
      body,
          (data) => OTPVerifyResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<OTPResendResponseModel>> resendOTP(String mfaToken) async {
    final body = {"mfaToken": mfaToken,};
    return requestNormal(
      APIPaths.retryOtpWithAction,
      Method.POST,
      body,
          (data) => OTPResendResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<EmptyCodable>> signup(String phone, String password) async {
    var deviceKey = await DeviceInfo.getDeviceId();
    final body = {"username": phone, "password": password.toSha256(), "device_key": deviceKey};
    return requestNormal(
      APIPaths.signup,
      Method.POST,
      body,
          (data) => EmptyCodable.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<EmptyCodable>> otpCreateNew(String ownerId,) async {
    var deviceKey = await DeviceInfo.getDeviceId();
    final body = {"owner_id": ownerId, "ttl": Constants.otpTtl, "resend_after_second": Constants.otpTtl};
    return requestNormal(
      APIPaths.otpCreateNew,
      Method.POST,
      body,
          (data) => EmptyCodable.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<CampaignDetailResponseModel>> websitePageGetDetail(String id) async {
    final body = {"website_page_id": "18756", "access_token": "",};
    return requestNormal(
      APIPaths.websitePageGetDetail,
      Method.POST,
      body,
          (data) => CampaignDetailResponseModel.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<CampaignDetailResponseModel>> websitePage(DetailPageRuleType rule) async {
    final body = {"code": rule.key,};
    return requestNormal(
      APIPaths.websitePage,
      Method.GET,
      body,
          (data) => CampaignDetailResponseModel.fromJson(data as Json),
    );
  }
}
