import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:local_auth/local_auth.dart';
import 'biometric_viewmodel.dart';

class BiometricAuthScreen extends StatefulWidget {
  const BiometricAuthScreen({super.key});

  @override
  State<BiometricAuthScreen> createState() => _BiometricAuthScreenState();
}

class _BiometricAuthScreenState extends State<BiometricAuthScreen> {
  final controller = Get.put(BiometricViewModel());

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        leading: null,
        title: Obx(() {
          String title = controller.biometricType.value == BiometricType.face ? "Face ID" : "Touch ID";
          return Text(title);
        }),
        backgroundColor: Colors.white,
        foregroundColor: Colors.black,
        elevation: 0,
      ),
      body: Obx(() {
        if (!controller.isAvailable.value) {
          return const Center(child: Text("Thiết bị không hỗ trợ sinh trắc học."));
        }
        String title = controller.biometricType.value == BiometricType.face ? "Kích hoạt xác thực Face ID" : "Kích hoạt xác thực vân tay";
        String description = controller.biometricType.value == BiometricType.face
            ? "Kích hoạt xác thực Face ID để đăng nhập nhanh không cần mật khẩu.\nBạn có muốn thực hiện không?"
            : "Kích hoạt xác thực vân tay để đăng nhập nhanh không cần mật khẩu.\nBạn có muốn thực hiện không?";
        IconData icon = controller.biometricType.value == BiometricType.face ? Icons.face : Icons.fingerprint;
        return Center(
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 20),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Icon(icon, size: 80, color: Colors.black54),
                const SizedBox(height: 20),
                Text(title, style: const TextStyle(fontSize: 24, fontWeight: FontWeight.bold)),
                const SizedBox(height: 10),
                Text(description, textAlign: TextAlign.center, style: const TextStyle(fontSize: 16, color: Colors.black54)),
                const SizedBox(height: 80),

                /// Nút kích hoạt
                Obx(() => SizedBox(
                  width: double.infinity,
                  child: ElevatedButton(
                    onPressed: controller.isAuthenticating.value ? null : controller.authenticate,
                    style: ElevatedButton.styleFrom(
                      padding: const EdgeInsets.symmetric(vertical: 15),
                      backgroundColor: Colors.redAccent,
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(10),
                      ),
                    ),
                    child: controller.isAuthenticating.value
                        ? const CircularProgressIndicator(color: Colors.white)
                        : const Text("Kích hoạt", style: TextStyle(color: Colors.white, fontSize: 18)),
                  ),
                )),
                const SizedBox(height: 10),

                /// Nút để sau
                TextButton(
                  onPressed: () => Get.back(),
                  child: const Text("Để sau", style: TextStyle(fontSize: 16, color: Colors.black54)),
                ),
              ],
            ),
          ),
        );
      }),
    );
  }
}
