import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:local_auth/local_auth.dart';

class BiometricViewModel extends GetxController {
  final LocalAuthentication _localAuth = LocalAuthentication();

  var biometricType = Rxn<BiometricType>(); // Loại sinh trắc học (Face ID / Touch ID)
  var isAvailable = false.obs; // Kiểm tra thiết bị có hỗ trợ sinh trắc học không
  var isAuthenticating = false.obs; // Trạng thái xác thực

  @override
  void onInit() {
    super.onInit();
    checkBiometricType();
  }

  /// Kiểm tra loại sinh trắc học có thể sử dụng
  Future<void> checkBiometricType() async {
    try {
      bool canCheckBiometrics = await _localAuth.canCheckBiometrics;
      List<BiometricType> availableBiometrics = await _localAuth.getAvailableBiometrics();

      isAvailable.value = canCheckBiometrics;
      if (availableBiometrics.contains(BiometricType.face)) {
        biometricType.value = BiometricType.face;
      } else if (availableBiometrics.contains(BiometricType.fingerprint)) {
        biometricType.value = BiometricType.fingerprint;
      }
    } catch (e) {
      print("Lỗi kiểm tra sinh trắc học: $e");
    }
  }

  /// Xác thực sinh trắc học
  Future<void> authenticate() async {
    isAuthenticating.value = true;
    try {
      bool authenticated = await _localAuth.authenticate(
        localizedReason: "Xác thực để kích hoạt đăng nhập nhanh",
        options: const AuthenticationOptions(
          biometricOnly: true,
          stickyAuth: true,
        ),
      );

      if (authenticated) {
        Get.snackbar("Thành công", "Xác thực sinh trắc học thành công!",
            backgroundColor: Colors.green, colorText: Colors.white);
      } else {
        Get.snackbar("Thất bại", "Xác thực không thành công!",
            backgroundColor: Colors.red, colorText: Colors.white);
      }
    } catch (e) {
      print("Lỗi xác thực: $e");
    }
    isAuthenticating.value = false;
  }
}
