import 'dart:async';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_core/src/get_main.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import 'package:mypoint_flutter_app/screen/login/login_screen.dart';
import '../../base/base_response_model.dart';
import '../../base/restful_api_viewmodel.dart';
import '../splash/splash_screen_viewmodel.dart';

abstract class ICreatePasswordRepository {
  late String phoneNumber;
  Future<bool?> createPassword(String newPassword);
  Future<BaseResponseModel<EmptyCodable>> signup(String password);
}

class SignUpCreatePasswordRepository extends RestfulApiViewModel implements ICreatePasswordRepository {
  @override
  late String phoneNumber;

  SignUpCreatePasswordRepository(this.phoneNumber);

  @override
  Future<BaseResponseModel<EmptyCodable>> signup(String password) async {
    showLoading();
    return client.signup(phoneNumber, password).then((value) {
      hideLoading();
      if (value.status == "success" || value.code == 200) {
        print("signup success");
        Get.off(() => LoginScreen(phoneNumber: phoneNumber));
      }
      return value;
    });
  }

  @override
  Future<bool?> createPassword(String newPassword) {
    // TODO: implement createPassword
    throw UnimplementedError();
  }
}
