import 'package:get/get.dart';
import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import 'package:mypoint_flutter_app/screen/onboarding/onboarding_screen.dart';
import '../../base/restful_api_viewmodel.dart';
import '../../permission/biometric_manager.dart';

// login_state_enum.dart
enum LoginState {
  idle,
  typing,
  done,
  error,
}

class LoginViewModel extends RestfulApiViewModel {
  final BiometricManager _biometricManager = BiometricManager();

  var loginState = LoginState.idle.obs;
  var isPasswordVisible = false.obs;
  var password = "".obs;
  var biometricType = BiometricTypeEnum.none.obs;

  @override
  void onInit() {
    super.onInit();
    _initBiometric();
  }

  Future<void> _initBiometric() async {
    final type = await _biometricManager.checkDeviceBiometric();
    biometricType.value = type;
  }

  Future<bool> canUseBiometrics() async {
    return _biometricManager.canCheckBiometrics();
  }

  void onPasswordChanged(String value) {
    password.value = value;
    if (value.isEmpty) {
      loginState.value = LoginState.idle;
    } else {
      loginState.value = LoginState.typing;
    }
  }

  void togglePasswordVisibility() {
    isPasswordVisible.value = !isPasswordVisible.value;
  }

  void onLoginPressed() {
    if (password.value.isEmpty) return;
    // Ví dụ: Mật khẩu chuẩn là "123456"
    if (password.value == "123456") {
      loginState.value = LoginState.done;
      debugPrint("Đăng nhập thành công!");
      // TODO: Chuyển màn hình
    } else {
      loginState.value = LoginState.error;
      debugPrint("Sai mật khẩu!");
    }
  }

  void onChangePhonePressed() {
    Get.back();
  }

  void onForgotPassPressed(String phoneNumber) {
    showLoading();
    client.otpCreateNew(phoneNumber).then((value) {
      hideLoading();
      print(value);
    });
  }

  /// Xác thực đăng nhập bằng sinh trắc
  Future<void> onBiometricLoginPressed(BuildContext context) async {
    // Kiểm tra thiết bị hỗ trợ
    final canUse = await canUseBiometrics();
    if (!canUse || biometricType.value == BiometricTypeEnum.none) {
      Get.snackbar("Thông báo", "Thiết bị không hỗ trợ sinh trắc học",
          snackPosition: SnackPosition.BOTTOM);
      return;
    }

    // Tuỳ chọn: hiển thị dialog xác nhận trước khi gọi authenticate
    final success = await _biometricManager.showCustomBiometricDialog(
      context,
      title: "Xác thực sinh trắc học",
      content: (biometricType.value == BiometricTypeEnum.faceId)
          ? "Bạn có muốn đăng nhập bằng Face ID không?"
          : "Bạn có muốn đăng nhập bằng vân tay không?",
      confirmText: "Đồng ý",
      cancelText: "Huỷ",
    );

    if (success) {
      loginState.value = LoginState.done;
      debugPrint("Đăng nhập bằng sinh trắc thành công!");
      // TODO: Chuyển màn hình
    } else {
      debugPrint("Xác thực thất bại hoặc người dùng huỷ.");
    }
  }
}
