// sign_up_otp_repository.dart
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import '../../base/base_response_model.dart';
import '../../base/restful_api_viewmodel.dart';
import 'model/otp_verify_response_model.dart';
import 'otp_viewmodel.dart';

class VerifyOtpRepository extends RestfulApiViewModel implements IOtpRepository {
  final String mfaToken;
  VerifyOtpRepository(this.phoneNumber, this.otpTtl, this.mfaToken);

  @override
  int otpTtl;
  @override
  String phoneNumber;

  @override
  Future<void> sendOtp() async {}

  @override
  Future<BaseResponseModel<OTPVerifyResponseModel>> verifyOtp(String otpCode) async {
    showLoading();
    return client.verifyOTP(otpCode, mfaToken).then((value) {
      hideLoading();
      return value;
    });
  }

  @override
  Future<int?> resendOtp() async {
      showLoading();
      return client.resendOTP(mfaToken).then((value) {
        hideLoading();
        return value.data?.otpTtl;
      });
  }
}
