import 'package:json_annotation/json_annotation.dart';
import 'media_type_item_campaign.dart';

part 'campaign_detail_item_model.g.dart';
@JsonSerializable()
class CampaignDetailItemModel {
  @JsonKey(name: "content_caption")
  String? contentCaption;

  @JsonKey(name: "content_text")
  String? contentText;

  @JsonKey(name: "media_type", fromJson: MediaTypeItemCampaign.fromString, toJson: _mediaTypeToJson)
  MediaTypeItemCampaign? mediaType;

  CampaignDetailItemModel({
    this.contentCaption,
    this.contentText,
    this.mediaType,
  });

  factory CampaignDetailItemModel.fromJson(Map<String, dynamic> json) =>
      _$CampaignDetailItemModelFromJson(json);

  Map<String, dynamic> toJson() => _$CampaignDetailItemModelToJson(this);

  /// 🎯 Helper để convert Enum sang String khi serialize JSON
  static String? _mediaTypeToJson(MediaTypeItemCampaign? type) => type?.toJson();
}

