enum DetailPageRuleType {
  privacyPolicy,
  termsOfUse,
  decree,
  policyDeleteAccount,
}

extension DetailPageRuleTypeExtension on DetailPageRuleType {
  String get key {
    switch (this) {
      case DetailPageRuleType.privacyPolicy:
        return "APP_SECURITY_POLICY";
      case DetailPageRuleType.termsOfUse:
        return "APP_TERM_OF_USE";
      case DetailPageRuleType.decree:
        return "DECREE_13";
      case DetailPageRuleType.policyDeleteAccount:
        return "APP_TERM_OF_DELETE_ACCOUNT";
    }
  }

  static DetailPageRuleType? fromString(String value) {
    switch (value) {
      case "APP_SECURITY_POLICY":
        return DetailPageRuleType.privacyPolicy;
      case "APP_TERM_OF_USE":
        return DetailPageRuleType.termsOfUse;
      case "DECREE_13":
        return DetailPageRuleType.decree;
      case "APP_TERM_OF_DELETE_ACCOUNT":
        return DetailPageRuleType.policyDeleteAccount;
    }
  }
}