import 'package:get/get.dart';
import 'package:mypoint_flutter_app/base/restful_api_viewmodel.dart';
import 'package:mypoint_flutter_app/networking/restful_api_request.dart';
import '../../base/base_response_model.dart';
import '../../model/update_response_object.dart';

class SplashScreenViewModel extends RestfulApiViewModel {
  var infoAppUpdate = BaseResponseModel<UpdateResponseObject>().obs;
  var isLoading = false.obs;

  void checkUpdateApp() {
    showLoading();
    isLoading(true);
    client.checkUpdateApp().then((value) {
      infoAppUpdate.value = value;
      hideLoading();
      isLoading(false);
    });
  }
}

class EmptyCodable {
  EmptyCodable.fromJson(dynamic json);

  Map<String, dynamic> toJson() {
    return {};
  }
}